/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;

public class TextSplitter {
    public static int splitTextIntoLines(final List<ITextComponent> dest, int minWidth, final int widthLimit, ITextComponent formattedText, final StringBuilder plainTextBuilder) {
        final SplitProgress progress = new SplitProgress();
        final int spaceWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(" ");
        progress.resultWidth = minWidth;
        final BiConsumer<Style, String> consumer = new BiConsumer<Style, String>(){

            @Override
            public void accept(Style style, String text) {
                boolean endsWithSpace;
                if (plainTextBuilder != null) {
                    plainTextBuilder.append(text);
                }
                if (endsWithSpace = text.endsWith(" ")) {
                    text = text + ".";
                }
                String[] parts = text.split(" ");
                boolean isEnd = style == null;
                for (int i = 0; i < parts.length; ++i) {
                    boolean isNewLine;
                    boolean canAddMultiword = isEnd || i < parts.length - 1;
                    String part = isEnd || endsWithSpace && i == parts.length - 1 ? "" : parts[i];
                    int partWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(part);
                    if (!canAddMultiword) {
                        progress.buildMultiword(part, partWidth, style);
                        continue;
                    }
                    int wordWidth = partWidth + progress.multiwordWidth;
                    int wordTakesWidth = wordWidth + (!progress.firstWord ? spaceWidth : 0);
                    if (progress.lineWidth + wordTakesWidth <= widthLimit) {
                        progress.resultWidth = Math.max(progress.resultWidth, Math.min(widthLimit, progress.lineWidth + wordTakesWidth));
                    }
                    if (progress.firstWord && progress.lineWidth + wordTakesWidth > progress.resultWidth) {
                        progress.resultWidth = progress.lineWidth + wordTakesWidth;
                    }
                    boolean bl = isNewLine = progress.multiword == null && part.equals("\\n");
                    if (!isNewLine && progress.lineWidth + wordTakesWidth <= progress.resultWidth) {
                        progress.confirmWord(part, style, wordTakesWidth);
                        continue;
                    }
                    progress.confirmComponent();
                    dest.add(progress.line);
                    progress.nextLine();
                    if (isNewLine) continue;
                    --i;
                }
            }
        };
        formattedText.iterator().forEachRemaining(new Consumer<ITextComponent>(){

            @Override
            public void accept(ITextComponent tc) {
                consumer.accept(tc.func_150256_b(), tc.func_150261_e());
            }
        });
        if (progress.multiword != null) {
            consumer.accept(null, "end");
        } else if (progress.stringBuilder.length() > 0) {
            progress.confirmComponent();
        }
        if (progress.line != null) {
            dest.add(progress.line);
        }
        if (progress.resultWidth > minWidth) {
            --progress.resultWidth;
        }
        return progress.resultWidth;
    }

    public static class SplitProgress {
        int multiwordWidth;
        List<ITextComponent> multiword = null;
        boolean firstWord = true;
        ITextComponent line = null;
        StringBuilder stringBuilder = new StringBuilder();
        int lineWidth;
        Style lastStyle;
        int resultWidth;

        public void buildMultiword(String wordPart, int width, Style style) {
            ITextComponent wordPartComponent = new TextComponentString(wordPart).func_150255_a(style);
            if (this.multiword == null) {
                this.multiword = new ArrayList<ITextComponent>();
            }
            this.multiword.add(wordPartComponent);
            this.multiwordWidth += width;
        }

        private void confirmWordPart(String part, Style style) {
            if (this.lastStyle != null && !Objects.equals(style, this.lastStyle)) {
                this.confirmComponent();
            }
            this.stringBuilder.append(part);
            this.lastStyle = style;
        }

        public void confirmWord(String lastPart, Style lastPartStyle, int width) {
            if (!this.firstWord) {
                this.stringBuilder.append(" ");
            }
            if (this.multiword != null) {
                for (ITextComponent component : this.multiword) {
                    String text = component.func_150261_e();
                    Style style = component.func_150256_b();
                    this.confirmWordPart(text, style);
                }
                this.multiword = null;
                this.multiwordWidth = 0;
            }
            this.confirmWordPart(lastPart, lastPartStyle);
            this.lineWidth += width;
            this.firstWord = false;
        }

        public void confirmComponent() {
            ITextComponent comp = new TextComponentString(this.stringBuilder.toString()).func_150255_a(this.lastStyle == null ? null : this.lastStyle);
            if (this.line != null) {
                if (this.stringBuilder.length() > 0) {
                    this.line.func_150253_a().add(comp);
                }
            } else {
                this.line = comp;
            }
            this.stringBuilder.delete(0, this.stringBuilder.length());
        }

        public void nextLine() {
            this.firstWord = true;
            this.line = null;
            this.lastStyle = null;
            this.lineWidth = 0;
        }
    }
}

